// reverse.java
// wykorzystanie stosu do odwracania sowa
// uruchomienie programu: C>java ReverseApp
import java.io.*;                 // operacje wejcia-wyjcia
////////////////////////////////////////////////////////////////
class StackX
   {
   private int maxSize;
   private char[] stackArray;
   private int top;
//--------------------------------------------------------------
   public StackX(int max)    // konstruktor
      {
      maxSize = max;
      stackArray = new char[maxSize];
      top = -1;
      }
//--------------------------------------------------------------
   public void push(char j)  // odkada element na stos
      {
      stackArray[++top] = j;
      }
//--------------------------------------------------------------
   public char pop()         // zdejmuje element ze stosu
      {
      return stackArray[top--];
      }
//--------------------------------------------------------------
   public char peek()        // podglda element na szczycie stosu
      {
      return stackArray[top];
      }
//--------------------------------------------------------------
   public boolean isEmpty()  // zwraca true jeeli stos pusty
      {
      return (top == -1);
      }
//--------------------------------------------------------------
   }  // koniec klasy StackX
////////////////////////////////////////////////////////////////
class Reverser
   {
   private String input;                // napis wejciowy
   private String output;               // napis wyjciowy
//--------------------------------------------------------------
   public Reverser(String in)           // konstruktor
      { input = in; }
//--------------------------------------------------------------
   public String doRev()                // odwraca napis
      {
      int stackSize = input.length();   // pobiera dugo napisu
      StackX theStack = new StackX(stackSize);  // tworzy stos o takiej pojemnoci

      for(int j=0; j<input.length(); j++)
         {
         char ch = input.charAt(j);     // pobiera kolejny znak z wejcia...
         theStack.push(ch);             // ...i odkada na stosie
         }
      output = "";
      while( !theStack.isEmpty() )
         {
         char ch = theStack.pop();      // zdejmuje znak ze stosu...
         output = output + ch;          // ...i docza do napisu wyjciowego
         }
      return output;
      }  // koniec doRev()
//--------------------------------------------------------------
   }  // koniec klasy Reverser
////////////////////////////////////////////////////////////////
class ReverseApp
   {
   public static void main(String[] args) throws IOException
      {
      String input, output;
      while(true)
         {
         System.out.print("Wprowad napis: ");
         System.out.flush();
         input = getString();          // wczytujemy napis z klawiatury
         if( input.equals("") )        // koniec, jeeli sam [Enter]
            break;
                                       // tworzymy obiekt odwracajcy sowa
         Reverser theReverser = new Reverser(input);
         output = theReverser.doRev(); // uywamy go
         System.out.println("Odwrcony: " + output);
         }  // koniec while
      }  // koniec main()
//--------------------------------------------------------------
   public static String getString() throws IOException
      {
      InputStreamReader isr = new InputStreamReader(System.in);
      BufferedReader br = new BufferedReader(isr);
      String s = br.readLine();
      return s;
      }
//--------------------------------------------------------------
   }  // koniec klasy ReverseApp
////////////////////////////////////////////////////////////////
